/**
 * \file               smac_802_15_4_shim.h        
 *
 * \version 1.0
 * first version
 *
 * \date               04-26-2007
 *
 * \author             mtalreja
 *
 * \warning           
 * 
 * \note              
 *
 * \review             
 * 
 * \bug                
 *
 **/


#ifndef SMAC_802_15_4_SHIM_H
#define SMAC_802_15_4_SHIM_H

#include "hprfgw_config.h"
#include "smac_pub_def.h"
#include "hprfgw_rfNwkMacInterface.h"
#include "hprfgw_rfAppAspInterface.h"
#include "hprfgw_rfMsgSystem.h"
#include "hprfgw_rfPublicConst.h"
#include "smac_app.h"

#if defined (OS_NUCLEUS)
 extern NU_MEMORY_POOL  System_Memory;
#endif

#define SMAC_SHIM_TASK_STACK_BYTES        (16*1024)
#ifndef RF_TASKS_BASE_PRIORITY
 #if defined (OS_NUCLEUS)
  #pragma info "!!!!Pass in the RF_TASKS_BASE_PRIORITY using the make file!!!!"
 #endif
#endif
#define SMAC_SHIM_TASK_PRIORITY           RF_TASK_PRIORITY(RF_TASKS_BASE_PRIORITY, 3)



#if defined (OS_NUCLEUS)
 #define mMlmeNwkInputQueue  (Rf_Smac_Shim.MlmeNwkInputQueue)
 #define mMcpsNwkInputQueue  (Rf_Smac_Shim.McpsNwkInputQueue)
 #define mAspNwkInputQueue   (Rf_Smac_Shim.AspNwkInputQueue)
#elif defined (OS_WINCE)
 // Do not change the define to Write Handles. See function MSG_InitQueue()
 // and also other MSG_* functions
 #define mMlmeNwkInputQueue  (Rf_Smac_Shim.hReadMlmeNwkInputQueue)
 #define mMcpsNwkInputQueue  (Rf_Smac_Shim.hReadMcpsNwkInputQueue)
 #define mAspNwkInputQueue   (Rf_Smac_Shim.hReadAspNwkInputQueue)
#elif defined (OS_LINUX)
 #define mMlmeNwkInputQueue  (Rf_Smac_Shim.hMlmeNwkInputQueue)
 #define mMcpsNwkInputQueue  (Rf_Smac_Shim.hMcpsNwkInputQueue)
 #define mAspNwkInputQueue   (Rf_Smac_Shim.hAspNwkInputQueue)
#endif



// Union to contain the largest message possible to the NWK layer
typedef union _toNwkMessage_t
{
  nwkMessage_t        nwkMessage;
  mcpsToNwkMessage_t  mcpsToNwkMessage;
  aspMsg_t            aspMsg;
} toNwkMessage_t;


// Union to contain the largest message possible from the NWK layer
typedef union _fromNwkMessage_t
{
  mlmeMessage_t       mlmeMessage;
  nwkToMcpsMessage_t  nwkToMcpsMessage;
  aspMsg_t            aspMsg;
} fromNwkMessage_t;


// Max header that can be shoved into the queue
typedef union _toFromNwkMessage_t
{
  toNwkMessage_t      toNwkMessage;
  fromNwkMessage_t    fromNwkMessage;
} toFromNwkMessage_t;


/**
 *
 * \date               04-27-2007
 *
 * \author             mtalreja
 * 
 * \brief              Structure to hold the frame control field of the data sent out over RF
 * 
 * \detail             IMPORTANT NOTE - THIS STRUCTURE MUST BE BYTE SWAPPED BECAUSE THE
 *                     ENDIANNESS OF THE STRUCTURE HAS TO BE REVERSED WHEN GOING OVER THE AIR
 * 
 **/
#pragma pack (1)
typedef struct _Rf_802_15_MAC_Data_FrameCtlField_struct
{
#if defined (HPRF_BIG_ENDIAN)
  UINT16        srcAddrMode:2;
  UINT16        frameVersion:2;
  UINT16        destAddrMode:2;
  UINT16        reserved:3;
  UINT16        panIDCompression:1;
  UINT16        ackRequest:1;
  UINT16        framePending:1;
  UINT16        securityEnabled:1;
  UINT16        frameType:3;
#else
  UINT16        frameType:3;
  UINT16        securityEnabled:1;
  UINT16        framePending:1;
  UINT16        ackRequest:1;
  UINT16        panIDCompression:1;
  UINT16        reserved:3;
  UINT16        destAddrMode:2;
  UINT16        frameVersion:2;
  UINT16        srcAddrMode:2;
#endif
}Rf_802_15_MAC_Data_FrameCtlField_struct;
#pragma pack()
/**
 *
 * \date               04-27-2007
 *
 * \author             mtalreja
 * 
 * \brief              Structure to hold the header of the data sent out over RF
 *                     For now ignore the security part of the header
 * 
 * \detail             
 * 
 **/
#pragma pack (1)
typedef struct _Rf_802_15_MAC_Data_FrameHdr_struct
{
  Rf_802_15_MAC_Data_FrameCtlField_struct frameCtl;
  UINT8         sequenceNo;
  UINT8         dstPanId[2];   // 16 bit word converted to little endian byte array
  UINT8         dstAddr[8];    // First 0/2/8 bytes is the address as defined by dstAddrMode
  UINT8         srcPanId[2];   // 16 bit word converted to little endian byte array
  UINT8         srcAddr[8];    // First 0/2/8 bytes is the address as defined by srcAddrMode
  // MNT - 4/27/2007 - Important Note:
  // Be careful when adding security details here. the data frame structure will change
  // Any data that is accessed using that structure might not work correctly. For the short
  // term - NO SECURITY :)
}Rf_802_15_MAC_Data_FrameHdr_struct;
#pragma pack ()


// MNT - 4/27/2007 - Max size should account for the 2 byte CRC as well
#define SMAC_MAXPACKETSIZE              (126)
#define RF_802_15_MAC_DATA_MAX_SIZE     (SMAC_MAXPACKETSIZE - 2 - sizeof(Rf_802_15_MAC_Data_FrameHdr_struct))

// Frame control field definitions
#define RF_802_15_MAC_FC_FRTYPE_BEACON    (0)
#define RF_802_15_MAC_FC_FRTYPE_DATA      (1)
#define RF_802_15_MAC_FC_FRTYPE_ACK       (2)
#define RF_802_15_MAC_FC_FRTYPE_MACCMD    (3)


#define RF_802_15_MAC_FC_ADDRMODE_NONE      (0)
#define RF_802_15_MAC_FC_ADDRMODE_RSVD      (1)
#define RF_802_15_MAC_FC_ADDRMODE_SHORT     (2)
#define RF_802_15_MAC_FC_ADDRMODE_EXT       (3)



/**
 *
 * \date               04-27-2007
 *
 * \author             mtalreja
 * 
 * \brief              Structure to hold the header of the data sent out over RF
 *                     For now ignore the security part of the header
 * 
 * \detail             
 * 
 **/
#pragma pack (1)
typedef struct _Rf_802_15_MAC_Data_Frame_struct
{
  Rf_802_15_MAC_Data_FrameHdr_struct    header;
  UINT8                                 data[RF_802_15_MAC_DATA_MAX_SIZE];
}Rf_802_15_MAC_Data_Frame_struct;
#pragma pack ()


/**
 *
 * \date               04-27-2007
 *
 * \author             mtalreja
 * 
 * \brief              Structure to hold the data sent to the SMAC Pipe
 * 
 * \detail             
 * 
 **/
#pragma pack (1)
typedef struct _Rf_802_15_MAC_TO_SMAC_Frame_struct
{
  UINT8                              msduHandle;
  Rf_802_15_MAC_Data_Frame_struct    RfData;
}Rf_802_15_MAC_TO_SMAC_Frame_struct;
#pragma pack ()


/**
 *
 * \date               06-11-2007
 *
 * \author             mtalreja
 * 
 * \brief              Structure to hold the data sent from the SMAC to the 802.15.4 layer
 * 
 * \detail             
 * 
 **/
#pragma pack (1)
typedef struct _SMAC_TO_Rf_802_15_MAC_Frame_struct
{
  UINT8                              Lqi;
  Rf_802_15_MAC_Data_Frame_struct    RfData;
}SMAC_TO_Rf_802_15_MAC_Frame_struct;
#pragma pack ()


#define SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE   (sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct) - sizeof(Rf_802_15_MAC_Data_Frame_struct))



/**
 *
 * \date               04-27-2007
 *
 * \author             mtalreja
 *
 * \brief              Structure to hold the header of the 802.15.4 confirmation data
 *                     sent out over RF
 *
 * \detail
 *
 **/
#pragma pack (1)
typedef struct _Rf_802_15_MAC_Data_Conf_struct
{
  Rf_802_15_MAC_Data_FrameCtlField_struct frameCtl;
  UINT8         seqNo;
}Rf_802_15_MAC_Data_Conf_struct;
#pragma pack ()





// Function Prototypes

uint8_t MLME_Set_Pib_Attribute(uint8_t  pibAttribute, uint8_t  *pibAttributeValue);
//uint8_t MLME_Get_Pib_Attribute(uint8_t  pibAttribute, uint8_t  *pibAttributeValue);
void Init_Smac_802_15_4_Shim(void);
#if defined (OS_NUCLEUS)
 void SmacShimTask(unsigned long argc, void *argv );
#elif defined (OS_WINCE)
 DWORD SmacShimTask(VOID* pContext );
#endif
void SetFrameCtlDefaults(Rf_802_15_MAC_Data_FrameCtlField_struct *frmCtl);

BOOL MSG_Pending(DM_RESOURCE_HANDLE hQueueHandle);

#if defined (HPRF_BIG_ENDIAN)
#define SMAC_SWAP_ENDIANNESS(a)\
{\
  UINT16 temp;\
  temp = (((UINT16)a & 0xFF) << 8) | (((UINT16)a & 0xFF00) >> 8)  ;\
  a = temp;\
}\

#else
#define SMAC_SWAP_ENDIANNESS(a)
#endif



#endif // #ifndef SMAC_802_15_4_SHIM_H
